
public class BufferBlock {
	private long startAddress;
	private byte[] bytes;
	private int size;
	private BufferBlock prev;
	private BufferBlock next;
	private boolean dirtyBit;
	
	public BufferBlock(int sz) {
		setStartAddress(-1);
		bytes = new byte[sz];
		this.size = sz;
		prev = null;
		next = null;
		setDirtyBit(false);
	}
	
	/** Copies size bytes starting from address to out + offset
	 * 
	 * @param out Destination array to copy bytes to
	 * @param offset Offset of position to write to in the destination array
	 * @param address Starting address in block to copy bytes from
	 * @param length Number of bytes to copy from the block
	 */
	public void getBytes(byte[] out, int offset, int address, int length) {
		for (int i = 0; i < length; i++) {
			out[i + offset] = bytes[address + i];
		}
	}
	
	/** Puts size bytes starting to address from in
	 * 
	 * @param in Source array to copy bytes from
	 * @param offset Offset position in the source array to copy from
	 * @param address Starting address in the block to copy bytes to
	 * @param length Number of bytes to copy into the block
	 */
	public void setBytes(byte[] in, int offset, int address, int length) {
		for (int i = 0; i < length; i++) {
			bytes[address + i] = in[i + offset]; 
		}
	}
	
	public BufferBlock getPrev() {
		return prev;
	}
	public void setPrev(BufferBlock prev) {
		this.prev = prev;
	}
	public BufferBlock getNext() {
		return next;
	}
	public void setNext(BufferBlock next) {
		this.next = next;
	}
	public int getSize() {
		return size;
	}
	public boolean isDirtyBit() {
		return dirtyBit;
	}
	public void setDirtyBit(boolean dirtyBit) {
		this.dirtyBit = dirtyBit;
	}
	public long getStartAddress() {
		return startAddress;
	}
	public void setStartAddress(long startAddress) {
		this.startAddress = startAddress;
	}
}
